<style>
    .report_patient_info .table {margin: 0;}
    .panel-body {font-family: serif;}
    .table-responsive {width: 100%;}
    .table_title {
        border: 1px solid #515151;
        display: inline-block;
        font-weight: bold;
        padding: 5px 25px;
        margin: 0 0 10px;
    }
    .report_content .table tr th,
    .report_content .table tr td {
        padding: 2px 0 !important;
        border: none !important;
        line-height: 17px;
    }
    .report_content {
        justify-content: space-between;
        align-items: flex-start;
        display: flex;
    }
    .report_graph img {
        margin-bottom: 10px;
        max-width: 100%;
    }
    .report_graph {width: 220px;}
    .report_graph .graph_title {
        border: 1px solid #000;
        border-left: none;
        padding: 2px 0;
        margin-top: 0;
        line-height: 17px;
        font-weight: bold;
    }
    .signature_area {
        justify-content: space-between;
        margin-top: 75px;
        display: flex;
    }
    .signature_area h5 {
        font-weight: 600;
        margin: 5px 0;
        color: #000;
    }
    .signature_box {padding: 0 45px;}
    @media print {
        .report_patient_info {
            border: 1px solid #515151 !important;
            margin: 145px 0 3px;
            padding: 5px 7px;
            border-radius: 10px;
        }
        .report_patient_info .table th,
        .report_patient_info .table td {
            padding: 0 5px !important;
            border: none !important;
        }
    }
</style>

<div class="container-fluid">
    <div class="row">
        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="panal-header-title">
                    <h1 class="pull-left">CBC Report</h1>
                    <a class="btn btn-primery pull-right" style="font-size: 14px; margin-top: 0;" onclick="window.print()"><i class="fa fa-print"></i> Print</a>
                </div>
            </div>
            
            <div class="panel-body">
                <div class="report_patient_info">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 100px;">Patient Name</th>
                            <td> : <?= $patient_histories[0]->patient_name ?></td>
                            <th style="width: 60px;">ID No</th>
                            <td> : <?php echo $patient_histories[0]->patient_id; ?></td>
                        </tr>
                        <tr>
                            <th>Print Date</th>
                            <td> : <?= date("Y-m-d"); ?></td>
                            <th>Age</th>
                            <td> : <?= $patient_histories[0]->age_year.'y '.$patient_histories[0]->age_month.'m '.$patient_histories[0]->age_day.'d' ?></td>
                        </tr>
                        <tr>
                            <th>Specimen</th>
                            <td> : Blood</td>
                            <th>Gender</th>
                            <td> : <?= $patient_histories[0]->gender ?></td>
                        </tr>
                        <tr>  
                            <th>Ref Doctor</th>
                            <td colspan="3"> : 
                                <?php 
                                    $ref_doctor = get_join('diagnosis', 'doctors', 'diagnosis.refereed_doctor=doctors.id', ['diagnosis.pid'=>$patient_histories[0]->patient_id], ['doctors.fullName as doctor_name', 'doctors.degree as doctor_degree']); 
                                    if(!empty($ref_doctor[0]->doctor_name)){
                                        echo $ref_doctor[0]->doctor_name . " (" . $ref_doctor[0]->doctor_degree . ")";
                                    }else{
                                        echo 'N/A';
                                    }
                                ?>
                            </td>
                        </tr>
                    </table>
                </div>
                <p class="text-center" style="margin-bottom: 12px; font-size: 16px;">(Estimations were carried out by Automated Meril CelQuant360 Haematology Analyzer & Verified manually)</p>
                
                <div class="text-center">
                    <h4 class="table_title">HAEMATOLOGY REPORT</h4>
                </div>
                <div class="report_content">
                    <div class="table-responsive">
                        <table class="table">
                            <tr style="border: 1px solid #000; border-right: none;">
                                <th>Test Name</th>
                                <th>Result</th>
                                <th style="width: 240px;">Reference Range</th>
                            </tr>
                            <tr>
                                <th>Hemoglobin (Hb)</th>
                                <th><span><?= $patient_histories[0]->hemoglobin ?></span> g/dl</th>
                                <td>M: 13-17, F & Child: 12.0-16.5 g/dl Infant: 13.0-19.0 g/dl</td>
                            </tr>
                            <tr>
                                <th>ESR (Westergren)</th>
                                <th><span><?= $patient_histories[0]->esr_w ?></span> mm/1st hr</th>
                                <td>M:0-10, F:0-20 mm/1st hr</td>
                            </tr>
                            <tr>
                                <th>TOTAL WBC COUNT</th>
                                <th><span><?= $patient_histories[0]->twc ?></span> /cumm</th>
                                <td>Adult: 4000-11000, Infant: 6000-18000, Child: 5000-1500, At Birth 10,000-25,000</td>
                            </tr>
                            <tr>
                                <th>DIFFERENTIAL COUNT</th>
                                <th><span><?= $patient_histories[0]->dc ?></span> </th>
                                <td></td>
                            </tr>
                            <tr>
                                <td>Neutrophils</td>
                                <th><span><?= $patient_histories[0]->neutrophils ?></span> %</th>
                                <td>Adult:40-70, Child: 20-50 %</td>
                            </tr>
                            <tr>
                                <td>Lymphocytes</td>
                                <th><span><?= $patient_histories[0]->lymphocytes ?></span> %</th>
                                <td>Adult:20-45, Child: 40-75 %</td>
                            </tr>
                            <tr>
                                <td>Monocytes</td>
                                <th><span><?= $patient_histories[0]->monocytes ?></span> %</th>
                                <td>02 - 08 %</td>
                            </tr>
                            <tr>
                                <td>Eosinophils</td>
                                <th><span><?= $patient_histories[0]->eosinophils  ?></span> %</th>
                                <td>01 - 06 %</td>
                            </tr>
                            <tr>
                                <td>Basophils</td>
                                <th><span><?= $patient_histories[0]->basophils ?></span> %</th>
                                <td>00 - 01 %</td>
                            </tr>
                            <tr>
                                <td>Total Cir, Eosinophil</td>
                                <th><span><?= $patient_histories[0]->tce ?></span> /cumm</th>
                                <td>50 - 450/cumm</td>
                            </tr>
                            <tr>
                                <th>Platelet Count</th>
                                <th><span><?= $patient_histories[0]->platelet_count ?></span> /cumm</th>
                                <td>150,000 - 400,000/cumm</td>
                            </tr>
                            <tr>
                                <td>MPV</td>
                                <td><span><?= $patient_histories[0]->mpv ?></span> fl</td>
                                <td>7.0 - 11.0 fl</td>
                            </tr>
                            <tr>
                                <td>PDW</td>
                                <td><span><?= $patient_histories[0]->pdw ?></span> %</td>
                                <td>10 - 18 %</td>
                            </tr>
                            <tr>
                                <td>PCT</td>
                                <td><span><?= $patient_histories[0]->pct ?></span> %</td>
                                <td>0.1 - 0.2 %</td>
                            </tr>
                            <tr>
                                <td>P-LCR</td>
                                <td><span><?= $patient_histories[0]->plcr ?></span> %</td>
                                <td>13.0 - 43.0 %</td>
                            </tr>
                            
                            <tr>
                                <th>RBC COUNT</th>
                                <th><span><?= $patient_histories[0]->rbc_count ?></span> m/ul</th>
                                <td>M: 4.5-6.5, F:3.8-5.5 m/ul</td>
                            </tr>
                            <tr>
                                <td>HCT/PCV</td>
                                <th><span><?= $patient_histories[0]->hct_pcv ?></span> %</th>
                                <td>M: 40-54%, F:37.47 %</td>
                            </tr>
                            <tr>
                                <td>MCV</td>
                                <td><span><?= $patient_histories[0]->mcv ?></span> fl</td>
                                <td>76 - 94 fl</td>
                            </tr>
                            <tr>
                                <td>MCH</td>
                                <td><span><?= $patient_histories[0]->mch ?></span> pg</td>
                                <td>27 - 32 pg</td>
                            </tr>
                            <tr>
                                <td>MCHC</td>
                                <td><span><?= $patient_histories[0]->mchc ?></span> g/dl</td>
                                <td>29 - 34 g/dl</td>
                            </tr>
                            <tr>
                                <td>RDW-CV</td>
                                <td><span><?= $patient_histories[0]->rdw_cv ?></span> %</td>
                                <td>10 - 16 %</td>
                            </tr>
                            <tr>
                                <td>RDW-SD</td>
                                <td><span><?= $patient_histories[0]->rdw_sd ?></span> fl</td>
                                <td>35 - 56 fl</td>
                            </tr>
                        </table>
                    </div>
                    
                    <div class="report_graph">
                        <h5 class="graph_title">Histogram</h5>
                        
                        <img src="<?php echo site_url('private/images/graph_1.png'); ?>" alt="">
                        <img src="<?php echo site_url('private/images/graph_2.png'); ?>" alt="">
                        <img src="<?php echo site_url('private/images/graph_3.png'); ?>" alt="">
                    </div>
                </div>
                
                <div class="signature_area">
                    <div class="signature_box"></div>
                    <div class="signature_box">
                        <h5>Sabah Al Bah Romi</h5>
                        <h5>Medical Technologist ( Lab )</h5>
                        <h5>DMLT( AFMI )-Dhaka, FT ( AFIP )</h5>
                    </div>
                </div>
            </div>
            <div class="panel-footer"> </div>
        </div>
    </div>
</div>
