<style>
    .title {
        border-bottom: 2px solid #000;
        text-transform: uppercase;
        display: inline-block;
        margin: 15px 0;
        color: #000;
        font-size: 19px;
        font-weight: 500;
    }
    .hide {display: none;}
    .heading_info_list {
        border: 1px solid #000;
        display: flex;
        flex-wrap: wrap;
        border-radius: 4px;
    }
    .heading_info_list li {
        min-width: 220px;
        display: flex;
        padding: 5px 0;
        width: 33.33%;
        padding: 2px 5px;
        font-weight: 500;
    }
    .heading_info_list li input:focus {
        box-shadow: none;
        outline: none;
    }
    .heading_info_list li input {
        box-shadow: none;
        padding: 0 10px;
        border: none;
        width: 100%;
        max-width: 100%;
        font-weight: 600;
    }
    .heading_info_list li span {
        display: inline-block;
        min-width: 100px;
    }
    .sub_title {
        display: inline-block;
        margin-bottom: 1px;
        padding: 5px 3px;
        background: #ddd;
        font-weight: 600;
    }
    .text_list {
        background: #eee;
        flex-wrap: wrap;
        display: flex;
    }
    .text_list li {
        min-width: 135px;
        padding: 3px;
        width: 20%;
        color: #000;
        font-weight: 500;
    }
    .text_list li input:focus {
        border: 1px solid #fff;
        box-shadow: none;
        outline: none;
    }
    .text_list li input {
        border: 1px solid #fff;
        display: inline-block;
        max-width: 35px;
        padding: 0;
        text-align: right;
        height: 20px;
        background: none;
    }
    .result_list li input {
        margin-left: 5px;
        height: 24px;
        padding: 0 8px;
        font-size: 14px;
    }
    .result_list li {
        align-items: center;
        margin: 5px 0;
        display: flex;
    }
    .result_list li strong {
        display: inline-block;
        min-width: 90px;
    }
    .impression_list {
        display: inline-block;
        background: #eee;
        width: 100%;
    }
    .impression_list li {
        list-style-type: disc;
        font-weight: 500;
        color: #000;
        margin: 2px 0 2px 25px;
    }
    .signature_box {margin-top: 25px;}
    .signature_box p {
        font-weight: 500;
        color: #000;
        margin: 0;
        font-size: 14px;
    }
    .signature_box h4 {
        display: inline-block; 
        border-top: 1px dashed #000; 
        color: #000; 
        margin: 0;
        font-size: 17px;
        padding-top: 5px;
    }
    
    @media print {
        aside, nav, .none, .panel-heading, .panel-footer {
            display: none !important;
        }
        .panel {
            border: 1px solid transparent;
            left: 0px;
            position: absolute;
            top: 0px;
            width: 100%;
        }
        .hide {display: block !important;}
        .block-hide {display: none;}
        .text_list li {padding: 0 3px;}
        .heading_info_list {
            border-radius: 12px;
            padding: 5px;
        }
    }
</style>
<div class="container-fluid">
    <div class="row">
        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="panal-header-title">
                    <h1 class="pull-left">ECHO Report</h1>
                    <a href="" class="pull-right" style="margin-top: 0px; font-size: 14px;" onclick="window.print()">
                        <i class="fa fa-print"></i> Print
                    </a>
                </div>
            </div>
            <div class="panel-body">
                <div class="text-center">
                    <h4 class="title">Echocardiography Report</h4>
                </div>
                <ul class="heading_info_list">
                    <?php  
                        $p_id = $this->uri->segment(4);
                        $patient_info = $this->action->read('ultra_patient', array('patient_id' => $p_id));
                    ?>
                    <li><span>Patient Name</span> : <input type="text" name="name" readonly
                            value="<?=($patient_info ? $patient_info[0]->name : '')?>">
                    <li><span>Patient ID</span> : <input type="text" name="patient_id" readonly
                            value="<?=($patient_info ? $patient_info[0]->patient_id : '')?>">
                    <li><span>MRD No</span> : <input type="text" name="mrd" readonly
                            value="<?=($patient_info ? $patient_info[0]->mrd : '')?>"></li>
                    <li><span>RIS No</span> : <input type="text" name="ris" readonly
                            value="<?=($patient_info ? $patient_info[0]->ris : '')?>" readonly></li>
                    </li>
                    <!--<li><span>Age</span> : <input type="text" name="age" readonly
                            value="<?=($patient_info ? $patient_info[0]->age : '')?>"></li>-->
                    <li><span>Age</span> : 
                        <input type="text" name="age" readonly value="<?=($patient_info ? $patient_info[0]->age_year.'y '.$patient_info[0]->age_month.'m '.$patient_info[0]->age_day.'d' : '')?>">
                    </li>
                    <li><span>Gender</span> : <input type="text" name="gender" readonly
                            value="<?=($patient_info ? $patient_info[0]->gender : '')?>" readonly></li>
                    <li><span>Bed No/Word</span> : <input type="text" name="bed" readonly
                            value="<?=($patient_info ? $patient_info[0]->bed : '')?>"></li>
                    <li><span>Bill Date</span> : <input type="text" value="<?=($patient_info ? $patient_info[0]->created_at : '')?>" readonly>
                    </li>
                    <li><span>Scan Date</span> : <input type="text" name="scan_date" readonly
                            value="<?=($patient_info ? $patient_info[0]->scan_date : '')?>">
                    </li>
                    <li><span>Report Date</span> : <input readonly type="text"
                            value="<?=($patient_info ? $patient_info[0]->created_at : '')?>">
                    </li>
                    <li><span>Report Status</span> : <input type="text" name="report_status" readonly
                            value="<?=($patient_info ? $patient_info[0]->report_status : '')?>"></li>
                    <li><span>Referred By</span> : <input type="text" name="reff_doctor" readonly
                            value="<?=($patient_info ? $patient_info[0]->reff_doctor : '')?>"></li>
                </ul>
                <div class="text-center">
                    <h4 class="title">2D Echo</h4>
                </div>
                <p style="margin-bottom: 15px; text-align: center; margin: 0;">Thank you for referring this case,
                    Findings are given
                    below.</p>

                <h6 class="sub_title">Measurement :</h6>
                <ul class="text_list">
                    <?php
                         foreach($result as $key => $row){ 
                             if(strtolower($row->test_name) != 'comments'){
                                 if($row->echo_report_comment==NULL){
                    ?>
                    <li>
                        <?php echo filter($row->test_name); ?> =
                        <input type="text" class="input_file" name="test_report[ivst]"
                            value="<?php echo strtoupper($row->test_report); ?>">mm
                    </li>
                    <?php } } } ?>
                </ul>

                <h6 class="sub_title">LV Function Indices :</h6>
                <ul class="result_list">
                    <?php 
                        foreach($result as $key => $row){ 
                          if($row->echo_report_comment !=NULL){
                    ?>
                    <li><strong><?= filter($row->test_name); ?></strong> :
                        <?php if($row->test_report=='Description'){ ?>
                        <em> <?= filter($row->echo_report_comment); ?> </em>
                        <?php }else{
                            echo filter($row->echo_report_comment); 
                        }} ?>
                    </li>
                    <?php } ?>
                </ul>
                
                <h6 class="sub_title">Comments :</h6>
                <p><?php echo $result[0]->echo_comment; ?></p>
                
                <div class="signature_box">
                    <h4>Dr. Md. Shafiqul Islam</h4>
                    <p>MBBS, MD (Cardiology)</p>
                    <p>Assistant Professor, Cardiology</p>
                    <p>Mymensingh Medical College & Hospital</p>
                    <p>Ex. NICVD</p>
                </div>
            </div>
            <div class="panel-footer">&nbsp;</div>
        </div>
    </div>
</div>