<style>
    .title {
        border-bottom: 2px solid #000;
        text-transform: uppercase;
        display: inline-block;
        margin: 15px 0;
        color: #000;
        font-size: 19px;
        font-weight: 500;
    }
    .hide {display: none;}
    .heading_info_list {
        border: 1px solid #000;
        display: flex;
        flex-wrap: wrap;
        border-radius: 4px;
    }
    .heading_info_list li {
        min-width: 220px;
        display: flex;
        padding: 5px 0;
        width: 33.33%;
        padding: 2px 5px;
        font-weight: 500;
    }
    .heading_info_list li input:focus {
        box-shadow: none;
        outline: none;
    }
    .heading_info_list li input {
        box-shadow: none;
        padding: 0 10px;
        border: none;
        width: 100%;
        max-width: 100%;
        font-weight: 600;
    }
    .heading_info_list li span {
        display: inline-block;
        min-width: 100px;
    }
    
    .header_info_list {
        flex-wrap: wrap;
        display: flex;
        border-top: 1px solid #000;
        border-left: 1px solid #000;
    }
    .header_info_list li {
        min-width: 220px;
        width: 33.3333%;
        padding: 5px;
        border-right: 1px solid #000;
        border-bottom: 1px solid #000;
    }
    .header_info_list li span {
        display: inline-block;
        min-width: 72px;
    }
    .header_info_list li input:focus {
        box-shadow: none;
        outline: none;
    }
    .header_info_list li input {
        padding: 0 5px 0 0;
        border: none;
        width: 50%;
        outline: none;
        box-shadow: none;
    }
    
    .sub_title {
        display: inline-block;
        margin-bottom: 1px;
        padding: 5px 3px;
        background: #ddd;
        font-weight: 600;
    }
    .text_list {
        background: #eee;
        flex-wrap: wrap;
        display: flex;
    }
    .text_list li {
        min-width: 135px;
        padding: 3px;
        width: 20%;
        color: #000;
        font-weight: 500;
    }
    .text_list li input:focus {
        border: 1px solid #fff;
        box-shadow: none;
        outline: none;
    }
    .text_list li input {
        border: 1px solid #fff;
        display: inline-block;
        max-width: 35px;
        padding: 0;
        text-align: right;
        height: 20px;
        background: none;
    }
    .result_list li input {
        margin-left: 5px;
        height: 24px;
        padding: 0 8px;
        font-size: 14px;
    }
    .result_list li {
        align-items: center;
        margin: 5px 0;
        display: flex;
    }
    .result_list li strong {
        display: inline-block;
        min-width: 90px;
    }
    .impression_list {
        display: inline-block;
        background: #eee;
        width: 100%;
    }
    .impression_list li {
        list-style-type: disc;
        font-weight: 500;
        color: #000;
        margin: 2px 0 2px 25px;
    }
    .signature_box {margin-top: 25px;}
    .signature_box p {
        font-weight: 500;
        color: #000;
        margin: 0;
        font-size: 14px;
    }
    .signature_box h4 {
        display: inline-block; 
        border-top: 1px dashed #000; 
        color: #000; 
        margin: 0;
        font-size: 17px;
        padding-top: 5px;
    }
    
    @media print {
        aside, nav, .none, .panel-heading, .panel-footer {
            display: none !important;
        }
        .panel {
            border: 1px solid transparent;
            left: 0px;
            position: absolute;
            top: 0px;
            width: 100%;
        }
    
        .hide {display: block !important;}
        .block-hide {display: none;}
        .text_list li {padding: 0 3px;}
    }
    
    .header_table tr th,
    .header_table tr td {
        border: 1px solid #000 !important;
        padding: 3px 5px !important;
    }
    .header_table span {
        display: inline-block;
        min-width: 72px;
    }
    .header_table input {
        padding: 0 5px 0 0;
        border: none;
        width: 50%;
        outline: none;
        box-shadow: none;
    }
</style>

    <div class="container-fluid">
    <div class="row">
        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="panal-header-title">
                    <h1 class="pull-left">Edit Echo Report</h1>
                    <a href="#" class="pull-right" style="margin-top: 0px; font-size: 14px;" onclick="window.print()">
                        <i class="fa fa-print"></i> Print
                    </a>
                </div>
            </div>
            <div class="panel-body">
                <div class="no-title">&nbsp;</div>
                <?php  $this->load->view('print'); ?>
                <?php echo $this->session->flashdata('confirmation');  ?>
                
                <form action="" method="POST">
                    <input type="hidden" name="patient_id" value="<?=($patient ? $patient[0]->pid : '')?>">
                    <div class="row visible">
                        <div class="col-md-offset-1 col-md-10">
                            <table class="table table-bordered header-table">
                                <tr>
                                    <td style="width: 100px;">NAME</td>
                                    <th>
                                        <?=($patient ? $patient[0]->name : '') ?>
                                    </th>
                                    <td style="width: 100px;">ID</td>
                                    <th>
                                        <?=($patient ? $patient[0]->pid : '') ?>
                                    </th>
                                </tr>
                                <tr>
                                    <td>AGE</td>
                                    <th>
                                        <div class="text">
                                            <input type="hidden" name="age_year" class="input_file" value="<?=($patient ? $patient[0]->age_year : '')?>">
                                            <input type="hidden" name="age_month" class="input_file" value="<?=($patient ? $patient[0]->age_month : '')?>">
                                            <input type="hidden" name="age_day" class="input_file" value="<?=($patient ? $patient[0]->age_day : '')?>">
                                            <span><?=($patient ? $patient[0]->age_year.'y '.$patient[0]->age_month.'m '.$patient[0]->age_day.'d' : '')?></span>
                                        </div>
                                    </th>
                                    <td>DATE</td>
                                    <th>
                                        <?php echo date("Y-m-d G.i:s", time()); ?>
                                    </th>
                                </tr>
                                <tr>
                                    <td>GENDER</td>
                                    <th>
                                        <div class="text">
                                            <input type="hidden" name="gender" class="input_file"
                                                value="<?=($patient ? $patient[0]->gender : '')?>"
                                                style="border: none; outline: 0" readonly>
                                            <span><?=($patient ? $patient[0]->gender : '')?></span>
                                        </div>
                                    </th>
                                    <td>SPECIMEN</td>
                                    <th>
                                        ECHO
                                    </th>
                                </tr>
                                <tr>
                                    <td>REFD :</td>
                                    <th colspan="3">
                                        <div class="text">
                                            
                                            <?php 
                                                $reff_doctor = get_name('ultra_patient', 'reff_doctor', ['patient_id'=>$patient[0]->pid]);
                                            ?>
                                            <input type="text" name="reff_doctor" class="input_file" value="<?= filter($reff_doctor) ?>"
                                                style="border: none; outline: 0">
                                            <span></span>
                                        </div>
                                    </th>
                                </tr>
                            </table>
                            <p style="margin-top: -10px; margin-bottom: 25px;">Thank you for referring this case, Findings are given below.</p>
                            
                           <div class="text-center">
                                <h4 class="title">Echocardiogram  Report : 2D, M- Mode.</h4>
                            </div>
                        
                            <h6 class="sub_title">2D & M-Mode measurements:</h6>
                            <ul class="header_info_list">
                                <?php
                                    foreach($echo_report as $key => $row){ 
                                ?>
                                <li><spsn><?= filter($row->test_name); ?></spsn> : 
                                    <input type="text" value="<?= $row->test_report ?>" name="test_report[]">
                                    mm  
                                    <input type="hidden" class="form-control input_file" name="id[]" value="<?= $row->id; ?>">
                                    <input type="hidden" value="<?= $row->test_name ?>" name="test_name[]">
                                </li>
                                <?php }?>
                            </ul>
                            
                            <h6 class="sub_title">LV Function Indices :</h6>
                            <ul class="result_list">
                                <?php 
                                    foreach($echo_report_comment as $key => $row){
                                ?>
                                <li>
                                    <strong><?= filter($row->test_name); ?></strong> :
                                    <input type="hidden" name="test_id[]" value="<?= $row->id; ?>">
                                    <input type="hidden" class="form-control input_file" name="echo_test_name[]" value="<?= $row->test_name; ?>">
                                    <input type="text" class="form-control input_file" name="echo_report_comment[]" <?php echo ($row->test_name=='Description') ? 'readonly':'' ?> value="<?= $row->echo_report_comment; ?>">
                                </li>
                               <?php } ?> 
                            </ul>
                            
                            <h6 class="sub_title">Comments :</h6>
                            <textarea id="tinyTextarea" name="echo_comment" rows="8" class="form-control">  
                               <?php 
                                    echo $echo_comment->echo_comment;
                               ?>  
                            </textarea>
                            
                            <div class="signature_box">
                                <h4 style="display: inline-block; border-top: 1px dashed #000; color: #000; margin: 0; padding-top: 5px;">Dr. Md. Shafiqul Islam</h4>
                                <p>MBBS, MD (Cardiology)</p>
                                <p>Assistant Professor, Cardiology</p>
                                <p>Mymensingh Medical College & Hospital</p>
                                <p>Ex. NICVD</p>
                            </div>

                            <div class="form-group">
                                <div class="btn-group pull-right">
                                    <input class="btn btn-success" type="submit" name="update" value="Update">
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="panel-footer">&nbsp;</div>
        </div>
    </div>
</div>
