<div class="container-fluid">
    <div class="row">
        <div class="panel panel-default none">
            <div class="panel-heading">
                <div class="panal-header-title">
                    <h1>All Diagnosis</h1>
                </div>
            </div>
            <div class="panel-body">
                <?php
                    $attribute = array(
                        'class' => '',
                    );
                    echo form_open('', $attribute);
                ?>
                <div class="row">
                    <div class="col-md-2">
                        <div class="form-group">
                            <div class="input-group date" id="datetimepicker1">
                                <input type="text" name="date[from]" class="form-control" placeholder="Form">
                                <span class="input-group-addon">
                                    <span class="glyphicon glyphicon-calendar"></span>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <div class="input-group date" id="datetimepicker2">
                                <input type="text" name="date[to]" class="form-control" placeholder="To">
                                <span class="input-group-addon">
                                    <span class="glyphicon glyphicon-calendar"></span>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <input type="text" name="voucher" class="form-control" placeholder="Voucher">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <input type="text" name="pid" class="form-control" placeholder="Patient ID">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <select name="refereed_doctor" class="form-control selectpicker" data-show-subtext="true" data-live-search="true">
                                <option value="" selected disabled>Select Refereed Doctor</option>
                                <?php foreach($doctors as $key =>$row){ ?>
                                <option value="<?= $row->id; ?>"><?= filter($row->fullName); ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <select name="alt_doctor_id" class="form-control selectpicker" data-show-subtext="true" data-live-search="true">
                                <option value="" selected disabled>Select Doctor (Ultra)</option>
                                <?php foreach($doctors as $key =>$row){ ?>
                                <option value="<?= $row->id; ?>"><?= filter($row->fullName); ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-1">
                        <div class="form-group">
                            <input type="submit" name="show" value="Show" class="btn btn-primary">
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>
            <div class="panel-footer">&nbsp;</div>
        </div>
        <?php echo $this->session->flashdata('confirmation'); ?>
        <div class="panel panel-default">
            <div class="panel-heading none">
                <div class="panal-header-title pull-left">
                    <h1>All Diagnosis </h1>
                </div>
                <a href="#" class="pull-right none" style="margin-top: 0px; font-size: 14px;" onclick="window.print()">
                    <i class="fa fa-print"></i>
                    Print
                </a>
            </div>
            <div class="panel-body">
                <!-- Print banner Start Here -->
                <?php  $this->load->view('print'); ?>

                <h4 class="hide">All Diagnosis</h4>

                <table class="table table-bordered" ng-cloak>
                    <tr>
                        <th class="text-center">SL</th>
                        <th>Date</th>
                        <th>Voucher No</th>
                        <th>Patient ID</th>
                        <th>Patient Name</th>
                        <th>Ultra(Doctor) Fee</th>
                        <th>Total</th>
                        <th>Paid</th>
                        <th>Remisson</th>
                        <th>Due</th>
                        <th>Cost</th>
                        <!--<th class="none">Status</th>-->
                        <th class="none">Action</th>
                    </tr>

                    <?php
                        $paid = 0;
                        $remission = 0;
                        $due = 0;
                        
                        $total_bill = 0;
                        $total_paid = 0;
                        $total_due = 0;
                        $total_remisson = 0;
                        
                        $totalCost = 0;

                        foreach($diagnasis_list as $key => $row){
                            
                            $where    = ["diagnosis.bill"=> $row->id];
                            $tableTo  = ['test', 'group_mapping', 'test_group'];
                            $joinCond = ['diagnosis.test_id=test.id', 'test.id=group_mapping.test_id', 'group_mapping.group_id=test_group.id'];
                            $select   = 'test.test_name as test, test.cost';
                    
                            $get_test_informations = $diagnosis = get_join('diagnosis', $tableTo, $joinCond, $where, $select, ['test.id']);
                            $cost = 0;
                            foreach($get_test_informations as $testCost){
                                $cost += $testCost->cost;
                            }
                            
                            $get_due_paid_records = get_result('due_payment', ['voucher_number'=>$row->voucher], ['voucher_number', 'paid as due_paid', 'remission as due_remission']);
                            $due_paid = 0;
                            $due_remission = 0;
                                if(!empty($get_due_paid_records)){
                                    foreach($get_due_paid_records as $due_paid_records){
                                        $due_paid +=  $due_paid_records->due_paid;
                                        $due_remission +=  $due_paid_records->due_remission;
                                    }
                                    
                                }else{
                                    $due_paid = 0;
                                    $due_remission = 0;
                                }
                            
                            $paid = $row->paid + $due_paid;
                            $remission = $row->discount + $due_remission;
                            $due = $row->due - $due_paid - $due_remission;


                            $total_bill += $row->grand_total;
                            $total_paid += $paid;
                            $total_due += $due;
                            $total_remisson += $remission;
                            $totalCost += $cost; 
                    ?>
                    <tr>
                        <td style="width: 40px;"><?= ($key+1); ?></td>
                        <td><?= $row->date; ?></td>
                        <td><?= $row->voucher; ?> </td>
                        <td><?= $row->pid; ?> </td>
                        <td><?= $row->name; ?></td>
                        <td><?= $row->alt_doctor_fee; ?></td>
                        <td><?= $row->grand_total; ?></td>
                        <td style="color: green;">
                            <b>
                                <?= $paid; ?>
                            </b>
                        </td>
                        <td style="color: green;"><b><?= $remission; ?></b></td>
                        <td style="color: red;"><b><?= $due; ?></b></td>
                        <td style="color: red;"><b><?= $cost; ?></b></td>

                        <td class="none" style="width: 160px;">
                            <?php //if($privilege !='user'){ ?>
                            <?php //if(ck_action("diagnosis_menu","view")){ ?>
                            <a title="View" class="btn btn-primary"
                                href="<?php echo site_url('diagnosis/addNewPatientDiagnosis/voucher?voucher=').$row->voucher;?>"><i
                                    class="fa fa-eye" aria-hidden="true"></i></a>
                            <?php //} ?>
                            <?php //if(ck_action("diagnosis_menu","edit")){ ?>
                            <a title="Edit" class="btn btn-warning"
                                href="<?php echo site_url('diagnosis/editTest?vno=').$row->voucher;?>"><i
                                    class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
                            <?php //} ?>
                            <?php //if(ck_action("diagnosis_menu","delete")){ ?>
                            <a title="Delete" class="btn btn-danger"
                                onclick="return confirm('Are you sure want to delete this Test info?');"
                                href="<?php echo site_url('diagnosis/deleteTest?vno=').$row->voucher;?>"><i
                                    class="fa fa-trash-o" aria-hidden="true"></i></a>
                            <?php //} ?>
                            <?php //} ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <tr>
                        <th colspan="5" class="text-right">Total</th>
                        <th></th>
                        <th><?php echo $total_bill; ?></th>
                        <th><?php echo $total_paid; ?></th>
                        <th><?php echo $total_remisson; ?></th>
                        <th><?php echo $total_due; ?></th>
                        <th><?php echo $totalCost; ?></th>
                        <th class="none"></th>
                    </tr>
                </table>
            </div>

            <div class="panel-footer">&nbsp;</div>
        </div>
    </div>
</div>
<script>
$('#datetimepicker1').datetimepicker({
    format: 'YYYY-MM-DD'
});
$('#datetimepicker2').datetimepicker({
    format: 'YYYY-MM-DD'
});
</script>