<?php class Cbc extends Admin_Controller {
    function __construct() {
        parent::__construct();
        
        $this->load->model('action');
    }

    public function index() {
        $this->data['meta_title']   = 'CBC Test';
        $this->data['active']       = 'data-target="tests"';
        $this->data['subMenu']      = 'data-target="cbc_add"';
        $this->data['confirmation'] = null;
        $this->data['all_test']     = [];
        $this->data['patient_info'] = [];
        $this->data['exist']        = [];
        
        $patient_info = [];
        if($_POST){
            
            $this->data['patient_info'] = get_row('patients', ['pid'=>$_POST['pid']]);
            
            $where                  = ['cbc_reports.patient_id' =>$_POST['pid']];
            $select                 = ['patients.name as patient_name', 'patients.address', 'patients.gender', 'patients.age_year', 'patients.age_month', 'patients.age_day', 'patients.contact', 'cbc_reports.*'];
            $this->data['exist']    = get_join('cbc_reports', 'patients', 'cbc_reports.patient_id=patients.pid', $where, $select, '', 'cbc_reports.date', 'DESC');
        }

        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/reports/nav', $this->data);
        $this->load->view('components/reports/cbc_add', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer', $this->data);
    }
    
    public function cbc_result_store(){
        
        if(!empty($_POST['save'])){
            
            $exist = get_row('cbc_reports', ['patient_id'=>$_POST['patient_id']]);
            if(empty($exist)){
                $data          =  $_POST;
                $data['date']  =  date('Y-m-d');
                unset($data['save']);  
                save_data('cbc_reports', $data);
                
                $options = array(
                "title" => "Success",
                "emit"  => "CBC Report Create Successfully Done",
                "btn"   => true
            );
                
            }else{
                
                $data          =  $_POST;
                $data['date']  =  date('Y-m-d'); 
                unset($data['save']);  
                save_data('cbc_reports', $data, ['patient_id'=>$_POST['patient_id']]);
                
                $options = array(
                    "title" => "Success",
                    "emit"  => "CBC Report Updated Successfully Done",
                    "btn"   => true
                );
            }
            
            $this->session->set_flashdata('confirmation', message('success', $options));
            
            redirect('reports/cbc/cbcList', 'refresh');
            
        }
    }

    public function cbcList() {
        
        $this->data['meta_title']   = 'CBC Test';
        $this->data['active']       = 'data-target="tests"';
        $this->data['subMenu']      = 'data-target="cbc_list"';
        $this->data['confirmation'] = null;
        
        $where = [];
        
        if(!empty($_POST['search'])){
            
            if(!empty($_POST['contact'])){
                $where['patients.contact'] = $_POST['contact']; 
            }
            
            if(!empty($_POST['pid'])){
                $where['patients.pid'] = $_POST['pid']; 
            }
            
            foreach($_POST['date'] as $key => $val){
                if($val != null && $key == 'form'){
                    $where['cbc_reports.date >='] = $val;
                }  
    
                if($val != null && $key == 'to'){
                    $where['cbc_reports.date <='] = $val;
                }
            }
        }else {
            $where['cbc_reports.date'] = date('Y-m-d');
        }
        
        $select = ['patients.name', 'patients.pid', 'patients.gender', 'patients.age_year', 'patients.age_month', 'patients.age_day', 'patients.contact', 'cbc_reports.date as created_at'];
        $this->data['patient_histories'] = get_join('cbc_reports', 'patients', 'cbc_reports.patient_id=patients.pid', $where, $select, 'patients.pid', 'cbc_reports.date', 'DESC');
        
        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/reports/nav', $this->data);
        $this->load->view('components/reports/cbc_list', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer', $this->data);
    }
    
    
    public function viewCbc($pid=null) {
        $this->data['meta_title']   = 'CBC Test';
        $this->data['active']       = 'data-target="tests"';
        $this->data['subMenu']      = 'data-target="cbc_view"';
        $this->data['confirmation'] = null;
    
        $where                              = ['cbc_reports.patient_id' =>$pid];
        $select                             = ['patients.name as patient_name', 'patients.address', 'patients.gender', 'patients.age_year', 'patients.age_month', 'patients.age_day', 'patients.contact', 'cbc_reports.*'];
        $this->data['patient_histories']    = get_join('cbc_reports', 'patients', 'cbc_reports.patient_id=patients.pid', $where, $select, '', 'cbc_reports.date', 'DESC');
        
        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/reports/nav', $this->data);
        $this->load->view('components/reports/cbc_view', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer', $this->data);
    }
    
    public function report_delete($pid)
    {
        $options = array(
            "title" => "danger",
            "emit"  => "Delete Successful!",
            "btn"   => true
        );
        
        $this->data['confirmation'] = message($this->action->deleteData('cbc_reports', array('patient_id'=>$pid)) , $options);
        $this->session->set_flashdata('confirmation', $this->data['confirmation']);
        redirect('/reports/cbc/cbcList', 'refresh');
    }
    
        // Patient Information
    public function patient_info(){
        
        if($_POST){
            
            foreach($_POST['parameter_id'] as $key=>$parameter){
                $record = [
                    'pid'           => $_POST['pid'],
                    'parameter_id'  => $parameter,
                    'test_id'       => $_POST['test_id'][$key],
                    'value'         => $_POST['result'][$key],
                    'description'   => '',
                ];
                
                $options = array(
                    "title" => "Success",
                    "emit"  => "Report Successfully Listed!",
                    "btn"   => true
                );
            
                //save_data('cbc_patient_histories', $record);
            
                $this->data['confirmation'] = message('success' , $options);
                $this->session->set_flashdata('confirmation', $this->data['confirmation']);
            }
            return redirect('reports/cbc/viewCbc/'.$_POST['pid']);
        }
        return redirect()->back();
    }
    
 }