<?php

class Diagnosis extends Admin_Controller {

     function __construct() {
        parent::__construct();

        $this->load->model('action');
    }
    
    public function index() {
        $this->data['meta_title'] = 'Diagnosis';
        $this->data['active'] = 'data-target="report_menu"';
        $this->data['subMenu'] = 'data-target="diagnosis"';
        $this->data['confirmation'] = null;
        $this->data['report'] = NULL;

/*        $this->data['testName'] = $this->action->readGroupBy('test_name','test_name');
        $this->data['groupName'] = $this->action->readGroupBy('group_name','group_name', ['trash'=>0]);*/
        
        // $tableTo  = ['test', 'group_mapping', 'test_group'];
        // $joinCond = ['diagnosis.test_id=test.id', 'test.id=group_mapping.test_id', 'group_mapping.group_id=test_group.id'];
        // $select   = 'diagnosis.*, test.*, test_group.group_name';
        
        // $this->data['diagnosis'] = get_join('diagnosis', $tableTo, $joinCond, [], $select, ['test.id']);
        
        $tableTo  = ['test', 'group_mapping'];
        $joinCond = ['diagnosis.test_id=test.id', 'test.id=group_mapping.test_id'];
        $select   = 'diagnosis.test_id, test.test_name';
        
        $this->data['testName'] = get_join('diagnosis', $tableTo, $joinCond, [], $select, ['diagnosis.test_id']);
        
        $tableTo  = ['test', 'group_mapping', 'test_group'];
        $joinCond = ['diagnosis.test_id=test.id', 'test.id=group_mapping.test_id', 'group_mapping.group_id=test_group.id'];
        $select   = 'diagnosis.group_id, test_group.group_name';
        
        $this->data['groupName'] = get_join('diagnosis', $tableTo, $joinCond, [], $select, ['diagnosis.group_id']);
        
        
        if (isset($_POST['show'])) {
            $where = array();
            foreach ($_POST['search'] as $key => $value) {
               
               if ($value != NULL && $key == 'test_id') {
                   $where['test_id'] = $value;
               }
               if ($value != NULL && $key == 'group_id') {
                   $where['group_id'] = $value;
               }
               
               if ($value != NULL && $key == 'date_from') {
                   $where['date >='] = $value;
               }

               if ($value != NULL && $key == 'date_to') {
                   $where['date <='] = $value;
               }
            }
            
            $this->data['report'] = $this->action->readGroupBy('diagnosis', 'pid', $where);
        }

        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/report/report-nav', $this->data);
        //$this->load->view('components/report/diagnosis', $this->data);
        $this->load->view('components/diagnosis/report', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer');
    }
}
