<?php

class Commission_list extends Admin_Controller {

    function __construct() {
        parent::__construct();

        $this->data['meta_title'] = 'marketer';
        $this->data['confirmation'] = null;
    }
    
    public function index() {
        $this->data['active'] = 'data-target="marketer-menu"';
        $this->data['subMenu'] = 'data-target="commission-list"';
        
        // get all marketer
        $this->data['allMarketer'] = get_result('marketer', ['trash' => 0]);
        
        $where = [];
        if(!$_POST){
           $where = ['from'=>date('Y-m-d'), 'type'=>'voucher']; 
        }else {
            $where = ['type'=>'voucher']; 
        }
        
        $this->data['results'] = $this->get_voucher($where);
        
        
        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/marketer/nav', $this->data);
        $this->load->view('components/marketer/commission-list', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer');
    }
    
    public function view($invoice){
        $this->data['active'] = 'data-target="marketer-menu"';
        $this->data['subMenu'] = 'data-target="commission-list"';

        $this->data['results']  = $results = $this->get_voucher(['invoice'=>$invoice]);
        
        if(!empty($results[0]->id)){
            $this->data['merketer'] = get_result('marketer', ['id'=>$results[0]->id])[0];
        }else{
            $this->data['merketer'] = [];
        }
        
        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/marketer/nav', $this->data);
        $this->load->view('components/marketer/view', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer');
    }
    
    private function get_voucher($where = ['type'=>'voucher']){
        
        $where = array_merge($where, (!empty($_POST['search']) ? $_POST['search'] : []));
        
        $condition = "";
        foreach($where as $key=>$value){
            if($key!='type' && $value!=''){
                if($key=='from')
                    $condition .= " AND bills.date >= '{$value}'"; 
                else if($key=='to')
                    $condition .= " AND bills.date <= '{$value}'"; 
                else if($key=='invoice')
                    $condition .= " AND bills.voucher = '{$value}'";     
                else 
                    $condition .= " AND marketer.{$key} = '{$value}'";    
            }
        }
        
        
        $result = $this->db->query("
            SELECT 
            marketer.*,
            marketer.id AS marketer_id,
            bills.id AS bill_id,
            bills.voucher,
            bills.date,
            bills.discount,
            test.test_name,
            test.rf_com,
            marketer.commission,
            test.fee,
            patients.name AS ptient_name
            FROM 
                diagnosis
            LEFT JOIN
                bills ON bills.id=diagnosis.bill
            LEFT JOIN 
                marketer ON diagnosis.reference_name=marketer.id
            LEFT JOIN
                test ON diagnosis.test_id=test.id
            LEFT JOIN
                patients ON bills.pid = patients.pid
            WHERE
                bills.status='diagnosis'
            AND
                marketer.trash=0
            {$condition}
            GROUP BY
                test.id
            ORDER BY 
                marketer.id ASC
        ")->result();
        
        
        if(array_key_exists('type', $where) && $where['type']=='voucher'){
            $voucher = [];
            foreach($result as $key=>$row){
                $voucher[$row->voucher]['date']         = $row->date;
                $voucher[$row->voucher]['name']         = $row->name;
                $voucher[$row->voucher]['ptient_name']  = $row->ptient_name;
                $voucher[$row->voucher]['mobile']       = $row->mobile;
                $voucher[$row->voucher]['rf_pc_commission']   = $row->commission;
                $voucher[$row->voucher]['address']      = $row->address;
                $voucher[$row->voucher]['img_url']      = $row->img_url;
                $voucher[$row->voucher]['voucher']      = $row->voucher;
                $voucher[$row->voucher]['marketer_id']  = $row->marketer_id;
                $commission = ($row->fee/100)*$row->rf_com;
                $voucher[$row->voucher]['commission'] = $commission;
            }
            $object = [];
            foreach($voucher as $row){
                $object[] = (object)$row;
            }
            return $object;
            
        }else{
            $marketer = [];
            foreach($result as $key=>$row){
                $marketer[] = $row;
            }
            return $marketer;
        }
    }

    
}