<?php class Field_doctorsk extends Admin_Controller {
    
    function __construct() {
        parent::__construct();
        
        $this->load->model('action');
        $this->data['meta_title'] = 'Field Doctor / SK';
    }
    

    public function index() {
        $this->data['active']  = 'data-target="field_doctorsk_menu"';
        $this->data['subMenu'] = 'data-target="add"';
        
        $this->data['areas'] = get_result('areas', ['trash'=>0], ['id', 'name']);
        
        if(!empty($_POST)){
            
            $data = $_POST;
            $data['date'] = date('Y-m-d');
        
            $options = array(
                "title" => "Success",
                "emit"  => "Data Successfully Submited",
                "btn"   => true
            );
            
            save_data('field_doctorsk', $data);
            
            $this->session->set_flashdata('confirmation', message('success', $options));
        
            redirect('field_doctorsk/field_doctorsk', 'refresh');
        }
        

        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/field_doctorsk/nav', $this->data);
        $this->load->view('components/field_doctorsk/add', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer', $this->data);
    }
    
    public function edit($id) {
        $this->data['active']  = 'data-target="field_doctorsk_menu"';
        $this->data['subMenu'] = 'data-target="add"';
        
        $this->data['areas'] = get_result('areas', ['trash'=>0], ['id', 'name']);
        
        if(!empty($_POST)){
            
            $data = $_POST;
            $data['date'] = date('Y-m-d');
        
            $options = array(
                "title" => "Success",
                "emit"  => "Data Successfully Update",
                "btn"   => true
            );
            
            save_data('field_doctorsk', $data, ['id'=>$id]);
            
            $this->session->set_flashdata('confirmation', message('success', $options));
        
            redirect('field_doctorsk/field_doctorsk/edit/'.$id, 'refresh');
        }
        
        $this->data['info'] = get_row('field_doctorsk', ['id'=>$id]);
        

        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/field_doctorsk/nav', $this->data);
        $this->load->view('components/field_doctorsk/edit', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer', $this->data);
    }

    public function all() {
        $this->data['active']  = 'data-target="field_doctorsk_menu"';
        $this->data['subMenu'] = 'data-target="all"';
        
        
        $this->data['areas'] = get_result('areas', ['trash'=>0], ['id', 'name']);
        $where = [];
        
        if(!empty($_POST['search'])){
            
            if(!empty($_POST['area_id'])){
                $where['area_id'] = $_POST['area_id'];
            }
            if(!empty($_POST['field_type'])){
                $where['field_type'] = $_POST['field_type'];
            }
            if(!empty($_POST['mobile'])){
                $where['mobile'] = $_POST['mobile'];
            }
        }
        
        
        $this->data['field_doctorsk_list'] = get_result('field_doctorsk', $where);

        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/field_doctorsk/nav', $this->data);
        $this->load->view('components/field_doctorsk/all', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer', $this->data);
    }
    
    
    public function area() {
        $this->data['active']  = 'data-target="field_doctorsk_menu"';
        $this->data['subMenu'] = 'data-target="area"';   
        
        
        if(!empty($_POST['name'])){
            
            $data = [
                'name' => $_POST['name'],
                'date'  => date('Y-m-d'),
            ];
        
            $options = array(
                "title" => "Success",
                "emit"  => "Area Name Successfully Submited",
                "btn"   => true
            );
            
            save_data('areas', $data);
            
            $this->session->set_flashdata('confirmation', message('success', $options));
        
            redirect('field_doctorsk/field_doctorsk/area', 'refresh');
        }
        
        $this->data['areas'] = get_result('areas', ['trash'=>0]);
        
        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/field_doctorsk/nav', $this->data);
        $this->load->view('components/field_doctorsk/area', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer', $this->data);
    }
    
    public function areaUpdate() {

        if(!empty($_POST['id'])){
            
            $data = ['name' => $_POST['name']];
        
            $options = array(
                "title" => "Success",
                "emit"  => "Area Name Successfully Update",
                "btn"   => true
            );
            
            save_data('areas', $data, ['id'=>$_POST['id']]);
            
            $this->session->set_flashdata('confirmation', message('success', $options));
        
            redirect('field_doctorsk/field_doctorsk/area', 'refresh');
        }
    }
    
    public function area_delete($id){
        
        
        save_data('areas', ['trash'=> 1], ['id'=>$id]);
        
        $options = array(
            "title" => "Delete",
            "emit"  => "Area Name Successfully Deleted",
            "btn"   => true
        );
            
        $this->session->set_flashdata('confirmation', message('success', $options));
        redirect('field_doctorsk/field_doctorsk/area', 'refresh');
    }
    
    public function getAreaNameById(){
        $id = $this->input->post('id');
        $data = [];
        if(!empty($id)){
            $data = get_row('areas', ['id'=>$id, 'trash'=>0]);
        }
        
        echo json_encode($data);
    }
        
    
    public function delete($id){
        
        
        $this->action->deleteData('field_doctorsk', ['id'=>$id]);
        
        $options = array(
            "title" => "Delete",
            "emit"  => "Data Successfully Deleted",
            "btn"   => true
        );
            
        $this->session->set_flashdata('confirmation', message('success', $options));
        redirect('field_doctorsk/field_doctorsk/all', 'refresh');
    }
}