<?php

class AllPatientDiagnosis extends Admin_Controller {

    function __construct() {
        parent::__construct();
        
        $this->load->model('action');
        $this->data['meta_title'] = 'New Diagnosis';
    }
    
    public function index() {
        $this->data['active'] = 'data-target="diagnosis-menu"';
        $this->data['subMenu'] = 'data-target="all"';

         // get all test
         $this->data['allTestName'] = $this->action->read('investigation'); 
         $this->data['doctors'] = $this->action->read("doctors", ['status'=>1]);  

         $where = ['bills.date'=>date('Y-m-d')];
         
         if(!empty($_POST['show'])){
            $where = [];
            if(!empty($_POST['date'])){
               
                foreach($_POST['date'] as $key => $val){

                    if($val != null && $key == 'from') {
                        $where['bills.'.'date >=']    = $val;
                    }
    
                    if($val != null && $key == 'to') {
                        $where['bills.'.'date <=']     = $val;
                    }
                }
            }


            if(!empty($_POST['refereed_doctor'])){
                $where['diagnosis.refereed_doctor']     = $_POST['refereed_doctor'];
            }
            
            if(!empty($_POST['alt_doctor_id'])){
                $where['diagnosis.alt_doctor_id']     = $_POST['alt_doctor_id'];
            }

            if(!empty($_POST['voucher'])){
                $where['bills.voucher']     = $_POST['voucher'];
            }
            
            if(!empty($_POST['pid'])){
                $where['bills.pid']     = $_POST['pid'];
            }

            /* if(!empty($_POST['test_name'])){
                $where['test_name']     = $_POST['test_name'];
            } */
            
         }

         $tableFrom = "bills";
         $tableTo   = ["patients", "diagnosis"];
         $joinCond  = ['bills.pid=patients.pid', 'bills.pid=diagnosis.pid'];

         $this->data['diagnasis_list'] = get_join($tableFrom, $tableTo, $joinCond, $where, ['bills.*', 'patients.name', 'diagnosis.alt_doctor_fee', 'diagnosis.test_id'], 'bills.voucher', 'bills.id', 'DESC');
       
       
       /*  echo "<pre>";
        print_r($this->data['diagnasis_list']); */
         

        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/diagnosis/nav', $this->data);
        $this->load->view('components/diagnosis/all', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer', $this->data);
    }
}