<?php
class Dashboard extends Admin_controller{

    function __construct() {
        parent::__construct();
        $this->holder();
        $this->load->model('action');
    }
    
    public function index() {
        $this->data['meta_title'] = 'dashboard';
        $this->data['active'] = 'data-target="dashboard"';
        $this->data['subMenu'] = 'data-target=""';        
        $this->data['totalDue'] = $this->data['totalProduct']  = 0;

        $this->data['totalDue'] = $this->data['totalProduct']  = 0;

        $this->data['patients'] = $this->action->read("patients");

        $this->data['doctors'] = $this->action->read("doctors");
        $this->data['pcDoctors'] = $this->action->read("pc");
        $this->data['employee'] = $this->action->read("employee");
        $this->data['marketer'] = $this->action->read("marketer");
        $this->data['costs'] = $this->action->read("cost");


        $this->data['totalDue'] = $this->data['totalProduct']  = 0;

        $this->data['patients'] = $this->action->read("patients");

        $this->data['doctors'] = $this->action->read("doctors", ['status'=>1]);
        $this->data['pcDoctors'] = $this->action->read("pc");
        $this->data['employee'] = $this->action->read("employee");
        $this->data['marketer'] = $this->action->read("marketer");
        $this->data['costs'] = $this->action->read("cost", ['date'=>date('Y-m-d')]);
        // $this->data['toIncome'] = $this->action->read("income", ['date'=>date('Y-m-d')]);


        // get total product
         $this->data['totalProduct'] = count($this->action->read('products'));

         
         $where = ['bills.date'=>date('Y-m-d')];
         $tableFrom = "bills";
         $tableTo   = ["patients", "diagnosis"];
         $joinCond  = ['bills.pid=patients.pid', 'bills.pid=diagnosis.pid'];

        $diagnasis_list = get_join($tableFrom, $tableTo, $joinCond, $where, ['bills.*', 'patients.name', 'diagnosis.alt_doctor_fee'], 'bills.voucher');
        
        $paid = 0;
        $remission = 0;
        $due = 0;
        
        $total_bill = 0;
        $total_paid = 0;
        $total_due = 0;
        $total_remisson = 0;

        foreach($diagnasis_list as $key => $row){
            
            $get_due_paid_records = get_result('due_payment', ['voucher_number'=>$row->voucher], ['voucher_number', 'paid as due_paid', 'remission as due_remission']);
            $due_paid = 0;
            $due_remission = 0;
                if(!empty($get_due_paid_records)){
                    foreach($get_due_paid_records as $due_paid_records){
                        $due_paid +=  $due_paid_records->due_paid;
                        $due_remission +=  $due_paid_records->due_remission;
                    }
                    
                }else{
                    $due_paid = 0;
                    $due_remission = 0;
                }
            
            $paid = $row->paid + $due_paid;
            $remission = $row->discount + $due_remission;
            $due = $row->due - $due_paid - $due_remission;


            $total_bill += $row->grand_total;
            $total_paid += $paid;
            $total_due += $due;
            $total_remisson += $remission;
        }


        $this->data['totalDue'] =  $total_due;
        
        
        $toIncome = $this->action->read_sum('income',"amount", ['date'=>date('Y-m-d')]);
        $this->data['toIncome'] = $toIncome[0]->amount;


        // get total Purchase
        $this->data['totalPurchase'] = $this->action->readGroupBy('purchase',"voucher_no",array("date" => date("Y-m-d")));
        // get total sale
        $this->data['totalSale'] = $this->action->readGroupBy('sale',"voucher_number",array("date" => date("Y-m-d")));
        

        $this->data['today_patients'] = $this->action->read("patients",array('date'=>date("Y-m-d")));
        $this->data['today_consultancy'] = get_result("consultancies",['date'=>date("Y-m-d")], ['id']);
        $this->data['today_operations'] = null;
        $this->data['today_investigation'] = $this->action->read("investigation");
        //$this->data['today_operations'] = $this->action->readGroupBy("patient_operation","patient_id",array('date'=>date("Y-m-d")));
        
		$this->data['today_diagnosis'] = get_join('bills', 'diagnosis', 'bills.id=diagnosis.bill', ['bills.date'=>date('Y-m-d')], 'bills.id', 'bills.voucher');
		
		
        $where = "AND patient_histories.created_at >= '".date('Y-m-d 00:00:00')."' AND patient_histories.created_at <= '".date('Y-m-d 23:59:59')."'";
        $this->data['today_total_report'] = $this->db->query("SELECT patients.*, patient_histories.test_name, patient_histories.created_at FROM patient_histories JOIN patients ON patient_histories.pid = patients.pid  WHERE patients.pid IN (SELECT pid FROM `patient_histories`) $where GROUP BY patients.pid")->result();
        
        $this->load->view('admin/includes/header', $this->data);
        $this->load->view('admin/includes/aside', $this->data);
        $this->load->view('admin/includes/headermenu', $this->data);
        $this->load->view('admin/dashboard', $this->data);
        $this->load->view('admin/includes/footer', $this->data);
    }

    private function holder(){
        if($this->uri->segment(1) != $this->session->userdata('holder')){
            $this->membership_m->logout();
            redirect('access/users/login');
        }
    }

}
