<style>
    .report_patient_info .table {margin: 0;}
    .panel-body {font-family: serif;}
    .table-responsive {width: 100%;}
    .report_content .table tr th,
    .report_content .table tr td {
        padding: 2px 0 !important;
        border: none !important;
        line-height: 20px;
    }
    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
      -webkit-appearance: none;
      margin: 0;
    }
    input[type=number] {
      -moz-appearance: textfield;
    }
    .report_content .table tr th input,
    .report_content .table tr td input {
        border: 1px dashed #aaa;
        max-width: 70px;
        outline: none;
        box-shadow: none;
        margin-right: 5px;
    }
    .report_content {
        justify-content: space-between;
        align-items: flex-start;
        display: flex;
    }
    .report_graph img {
        margin-bottom: 10px;
        max-width: 100%;
    }
    .report_graph {width: 225px;}
    .report_graph .graph_title {
        border: 1px solid #000;
        border-left: none;
        padding: 2px 0;
        margin-top: 0;
        line-height: 20px;
        font-weight: bold;
    }
    .report_patient_info {margin-bottom: 15px;}
    @media print {
        .report_patient_info {
            border: 1px solid #515151 !important;
            margin: 145px 0 15px;
            padding: 5px 7px;
            border-radius: 10px;
        }
        .report_patient_info .table th,
        .report_patient_info .table td {
            padding: 0 5px !important;
            border: none !important;
        }
    }
</style>
<div class="container-fluid block-hide" ng-controller="testCbcController">
    <div class="row">
        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="panal-header-title">
                    <h1 class="pull-left">New CBC Report</h1>
                    <a class="btn btn-primery pull-right" style="font-size: 14px; margin-top: 0;" onclick="window.print()"><i class="fa fa-print"></i> Print</a>
                </div>
            </div>
               
            <div class="panel-body">
                <form action="#" class="none" method="POST">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <input class="form-control" type="text" name="pid" placeholder="Search by Patient ID" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <input class="btn btn-primary" type="submit" value="Search">
                            </div>
                        </div>
                    </div>
                </form>
                <hr class="none">
                
                <?php if(!empty($patient_info)){ ?>
                <div class="report_patient_info">
                    <table class="table table-bordered">
                        <tr>
                            <th style="width: 100px;">Patient Name</th>
                            <td> : <?= $patient_info->name ?></td>
                            <th style="width: 60px;">ID No</th>
                            <td> : <?php echo $patient_info->pid; ?> <input type="hidden" name="pid" value="<?php echo $patient_info->pid; ?>"></td>
                        </tr>
                        <tr>
                            <th>Print Date</th>
                            <td> : <?= date("Y-m-d G.i:s<br>", time()); ?></td>
                            <th>Age</th>
                            <td> :<?= $patient_info->age_year.'y '.$patient_info->age_month.'m '.$patient_info->age_day.'d' ?></td>
                        </tr>
                        <tr>
                            <th>Specimen</th>
                            <td> : Blood</td>
                            <th>Gender</th>
                            <td> : <?= $patient_info->gender ?></td>
                        </tr>
                        <tr>
                            <th>Ref Doctor</th>
                            <td colspan="3"> : 
                                <?php 
                                    $ref_doctor = get_join('diagnosis', 'doctors', 'diagnosis.refereed_doctor=doctors.id', ['diagnosis.pid'=>$patient_info->pid], 'doctors.fullName as doctor_name'); 
                                    echo (!empty($ref_doctor[0]->doctor_name) ? $ref_doctor[0]->doctor_name : 'N/A')
                                ?>
                            </td>
                        </tr>
                    </table>
                </div>
                
                <form action="<?php echo site_url('reports/cbc/cbc_result_store')?>" method="POST">
                    <input type="hidden" name="patient_id" value="<?= $patient_info->pid;?>" required>
                    <div class="report_content">
                        <div class="table-responsive">
                            <table class="table">
                                <tr style="border: 1px solid #000; border-right: none;">
                                    <th>Test Name</th>
                                    <th>Result</th>
                                    <th style="width: 240px;">Reference Range</th>
                                </tr>
                                <tr>
                                    <th>Hemoglobin (Hb)</th>
                                    <th><input type="number" name="hemoglobin" step="any" value="<?= (!empty($exist[0]->hemoglobin) ? $exist[0]->hemoglobin ? $exist[0]->hemoglobin : '' : '') ?>">g/dl - 70.0%</th>
                                    <td>M: 13-17, F & Child: 12.0-16.5 g/dl Infant: 13.0-19.0 g/dl</td>
                                </tr>
                                <tr>
                                    <th>ESR (Westergren)</th>
                                    <th><input type="number" name="esr_w" step="any" value="<?= (!empty($exist[0]->esr_w) ? $exist[0]->esr_w ? $exist[0]->esr_w : '' : '') ?>">mm/1st hr</th>
                                    <td>M:0-10, F:0-20 mm/1st hr</td>
                                </tr>
                                <tr>
                                    <th>TOTAL WBC COUNT</th>
                                    <th><input type="number" name="twc" step="any" ng-model="twc" ng-init="twc='<?= (!empty($exist[0]->twc) ? $exist[0]->twc ? $exist[0]->twc : '' : '') ?>'" ng-value="twc" ng-change="getTceFn()">/cumm</th>
                                    <td>Adult: 4000-11000, Infant: 6000-18000, Child: 5000-1500, At Birth 10,000-25,000</td>
                                </tr>
                                <tr>
                                    <th>DIFFERENTIAL COUNT</th>
                                    <th><input type="text" name="dc" step="any" value="<?= (!empty($exist[0]->dc) ? $exist[0]->dc ? $exist[0]->dc : '' : '') ?>"></th>
                                    <td></td>
                                </tr>
                                <tr>
                                    <td>Neutrophils</td>
                                    <th><input type="number" name="neutrophils" step="any" value="<?= (!empty($exist[0]->neutrophils) ? $exist[0]->neutrophils ? $exist[0]->neutrophils : '' : '') ?>">%</th>
                                    <td>Adult:40-70, Child: 20-50 %</td>
                                </tr>
                                <tr>
                                    <td>Lymphocytes</td>
                                    <th><input type="number" name="lymphocytes" step="any" value="<?= (!empty($exist[0]->lymphocytes) ? $exist[0]->lymphocytes ? $exist[0]->lymphocytes : '' : '') ?>">%</th>
                                    <td>Adult:20-45, Child: 40-75 %</td>
                                </tr>
                                <tr>
                                    <td>Monocytes</td>
                                    <th><input type="number" name="monocytes" step="any" value="<?= (!empty($exist[0]->monocytes) ? $exist[0]->monocytes ? $exist[0]->monocytes : '' : '') ?>">%</th>
                                    <td>02 - 08 %</td>
                                </tr>
                                <tr>
                                    <td>Eosinophils</td>
                                    <th><input type="number" name="eosinophils" step="any" ng-model="eosinophils" ng-init="eosinophils='<?= (!empty($exist[0]->eosinophils) ? $exist[0]->eosinophils ? $exist[0]->eosinophils : '' : '') ?>'" ng-change="getTceFn()" ng-value="eosinophils" >%</th>
                                    <td>01 - 06 %</td>
                                </tr>
                                <tr>
                                    <td>Basophils</td>
                                    <th><input type="number" name="basophils" step="any" value="<?= (!empty($exist[0]->basophils) ? $exist[0]->basophils ? $exist[0]->basophils : '' : '') ?>">%</th>
                                    <td>00 - 01 %</td>
                                </tr>
                                <tr>
                                    <td>Total Cir, Eosinophil</td>
                                    <th><input type="text" readonly ng-model="tce" ng-init="tce='<?= (!empty($exist[0]->tce) ? $exist[0]->tce ? $exist[0]->tce : '' : '') ?>'" step="any" name="tce" >/cumm</th>
                                    <td>50 - 450/cumm</td>
                                </tr>
                            
                            
                                <tr>
                                    <th>Platelet Count</th>
                                    <th><input type="text" name="platelet_count" step="any" value="<?= (!empty($exist[0]->platelet_count) ? $exist[0]->platelet_count ? $exist[0]->platelet_count : '' : '') ?>">/cumm</th>
                                    <td>150,000 - 400,000/cumm</td>
                                </tr>
                                <tr>
                                    <td>MPV</td>
                                    <td><input type="number" name="mpv" step="any" value="<?= (!empty($exist[0]->mpv) ? $exist[0]->mpv ? $exist[0]->mpv : '' : '') ?>"> fl</td>
                                    <td>7.0 - 11.0 fl</td>
                                </tr>
                                <tr>
                                    <td>PDW</td>
                                    <td><input type="number" name="pdw" step="any" value="<?= (!empty($exist[0]->pdw) ? $exist[0]->pdw ? $exist[0]->pdw : '' : '') ?>"> %</td>
                                    <td>10 - 18 %</td>
                                </tr>
                                <tr>
                                    <td>PCT</td>
                                    <td><input type="number" name="pct" step="any" value="<?= (!empty($exist[0]->pct) ? $exist[0]->pct ? $exist[0]->pct : '' : '') ?>"> %</td>
                                    <td>0.1 - 0.2 %</td>
                                </tr>
                                <tr>
                                    <td>P-LCR</td>
                                    <td><input type="number" name="plcr" step="any" value="<?= (!empty($exist[0]->plcr) ? $exist[0]->plcr ? $exist[0]->plcr : '' : '') ?>"> %</td>
                                    <td>13.0 - 43.0 %</td>
                                </tr>
                            
                                <tr>
                                    <th>RBC COUNT</th>
                                    <th><input type="number" name="rbc_count" step="any" value="<?= (!empty($exist[0]->rbc_count) ? $exist[0]->rbc_count ? $exist[0]->rbc_count : '' : '') ?>">m/ul</th>
                                    <td>M: 4.5-6.5, F:3.8-5.5 m/ul</td>
                                </tr>
                                <tr>
                                    <td>HCT/PCV </td>
                                    <th><input type="number" name="hct_pcv" step="any" value="<?= (!empty($exist[0]->hct_pcv) ? $exist[0]->hct_pcv ? $exist[0]->hct_pcv : '' : '') ?>">%</th>
                                    <td>M: 40-54%, F:37.47 %</td>
                                </tr>
                                <tr>
                                    <td>MCV</td>
                                    <td><input type="number" name="mcv" step="any" value="<?= (!empty($exist[0]->mcv) ? $exist[0]->mcv ? $exist[0]->mcv : '' : '') ?>">fl</td>
                                    <td>76 - 94 fl</td>
                                </tr>
                                <tr>
                                    <td>MCH</td>
                                    <td><input type="number" name="mch" step="any" value="<?= (!empty($exist[0]->mch) ? $exist[0]->mch ? $exist[0]->mch : '' : '') ?>">pg</td>
                                    <td>27 - 32 pg</td>
                                </tr>
                                <tr>
                                    <td>MCHC </td>
                                    <td><input type="number" name="mchc" step="any" value="<?= (!empty($exist[0]->mchc) ? $exist[0]->mchc ? $exist[0]->mchc : '' : '') ?>">g/dl</td>
                                    <td>29 - 34 g/dl</td>
                                </tr>
                                <tr>
                                    <td>RDW-CV</td>
                                    <td><input type="number" name="rdw_cv" step="any" value="<?= (!empty($exist[0]->rdw_cv) ? $exist[0]->rdw_cv ? $exist[0]->rdw_cv : '' : '') ?>">%</td>
                                    <td>10 - 16 %</td>
                                </tr>
                                <tr>
                                    <td>RDW-SD</td>
                                    <td><input type="number" name="rdw_sd" step="any" value="<?= (!empty($exist[0]->rdw_sd) ? $exist[0]->rdw_sd ? $exist[0]->rdw_sd : '' : '') ?>">fl</td>
                                    <td>35 - 56 fl</td>
                                </tr>
                            </table>
                        </div>
                        
                        <div class="report_graph">
                            <h5 class="graph_title">Histogram</h5>
                            
                            <img src="<?php echo site_url('private/images/graph_1.png'); ?>" alt="">
                            <img src="<?php echo site_url('private/images/graph_2.png'); ?>" alt="">
                            <img src="<?php echo site_url('private/images/graph_3.png'); ?>" alt="">
                        </div>
                    </div>  
                    <div class="text-right none"><input type="submit" name="save" class="btn btn-primary"></div>
                </form>
                <?php } ?>
            </div>
            
            <div class="panel-footer">&nbsp;</div>
        </div>
    </div>
</div>
