<?php

class AddNewPatientDiagnosis extends Admin_Controller {

    function __construct() {
        parent::__construct();
        
        $this->load->model('action');
        $this->load->helper('barcode');
        $this->data['meta_title'] = 'New Diagnosis';
        
        
        $totalPatient = custom_query("SELECT COUNT(*) AS total_patient FROM `patients`", true);
        $totalPatient = (!empty($totalPatient->total_patient) ? ($totalPatient->total_patient+1) : 1);
        $paid = str_pad($totalPatient, 5, 0, STR_PAD_LEFT);
        
        while(check_exists('patients', ['pid' => $paid])){
            $paid = str_pad($paid, 5, 0, STR_PAD_LEFT) + 1;
        }
        
        $this->data['pid'] = $paid;
        $this->data['patient_id'] = $paid;
        
        $this->data['voucher'] = date("Ymd")."001";
        while(!empty(get_result('bills', ['voucher'=>$this->data['voucher']]))){
            $this->data['voucher'] = $this->data['voucher']+1;
        }
        
    }

    public function index() {
        
        $this->data['active'] = 'data-target="diagnosis-menu"';
        $this->data['subMenu'] = 'data-target="add"';

       
        // get all test
        $this->data['allTestName'] = $this->action->read('test', ['trash'=>0]);  
        
        $this->data['pid'] = $this->input->get("pid"); 
    
    
        $this->data['doctors'] = $this->action->read("doctors", ['status'=>1]);      
        $this->data['reference'] = $this->action->read("marketer", ['trash' => 0]); 

        $tableFrom = 'patients';
        $tableTo   = 'bills';
        
        $joinCond ='patients.pid=bills.pid';
        $where    = ['bills.title'=>'consultancy', 'patients.name !='=>''];
        
        $this->data['patient_idInfo'] = get_join($tableFrom, $tableTo,$joinCond, $where);
        
        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/diagnosis/nav', $this->data);
        $this->load->view('components/diagnosis/add', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer', $this->data);
    }

    public function add(){
        $patientsInfo = array(
            'pid'         => $this->data['pid'],
            'name'        => $this->input->post("patient_name"),
            'contact'     => $this->input->post("contact_number"),
            //"age_type"  => $this->input->post('age_type'),
            //'age'       => $this->input->post("age"),
            'age_year'    => $this->input->post("age_year"),
            'age_month'   => $this->input->post("age_month"),
            'age_day'     => $this->input->post("age_day"),
            'address'     => $this->input->post("address"),
            'gender'      => $this->input->post("gender"),
            'date'        => $this->input->post("date"),
        );
        $this->action->add('patients', $patientsInfo);
        
       $billID = $this->addBill();
                 $this->addJournal();

        foreach ($_POST['test_id'] as $key => $value) {
            $data = array(
              "date"            => $this->input->post("date"),
              "delivery"        => $this->input->post("delivery_date"),
              "pid"             => $this->data['pid'],
              "group_id"        => $_POST['group_id'][$key],
              "test_id"         => $value,
              "reference_name"  => $this->input->post('reference_name'),
              "bill"            => $billID,
              // "name"         => $value,
              // "group"        => $_POST["test_group"][$key],
              // "room"         => $_POST["room_no"][$key],
              // "amount"       => $_POST['amount'][$key],
              // "cost"         => $_POST['cost'][$key],
              "refereed_doctor" => $this->input->post("refereed_doctor"),
              'alt_doctor_id'   => $this->input->post('alt_doctor_id'),
              'alt_doctor_fee'  => $this->input->post('alt_doctor_fee'),
              'user_id'         => $this->data['user_id'],
              'discount_by'     => $this->input->post('discount_by'),
              "status"          => "pending",
            );
            
           $this->action->add("diagnosis", $data);
        }
        // end patients add
        
        redirect("diagnosis/addNewPatientDiagnosis/voucher?voucher=". ($this->data['voucher']), "refresh");
    }


    private function addBill() {
        
        $data = array(
            "date"                  => date("Y-m-d"),
            "time"                  => date("h:i:s A"),
            "voucher"               => $this->data['voucher'],
            "pid"                   => $this->data['pid'],
            "title"                 => "diagnosis",
            "details"               => "diagnosis",
            "subtotal"              => $this->input->post("subtotal"),
            "vat"                   => $this->input->post("vat"),
            "vat_amount"            => $this->input->post("vat_amount"),
            "total"                 => $this->input->post('total'),
            "discount"              => $this->input->post('discount'),
            "less_type"             => $this->input->post('less_type'),
            "grand_total"           => $this->input->post('grand_total'),
            "paid"                  => $this->input->post('paid'),
            "due"                   => $this->input->post('due'),
            "last_paid"             => $this->input->post('paid'),
            "last_payment_date"     => $this->input->post('date'),
            "user_id"               => $this->session->userdata['user_id'],
            "other_rf_doctor"       => $this->input->post('other_rf_doctor'),
            "delivery_time"         => $this->input->post('delivery_time'),
            "service_charge"        => $this->input->post('service_charge'),
            "status"                => "diagnosis"
        );
        

        $id = $this->action->addAndGetInsertedID('bills', $data);
        
       //Voucher Bar code generating Start here----------------      
        
        $barcode       = $this->action->read('barcode');
        $font          = './private/fonts/arialbd.ttf';
        // - -
        
        $fontSize     = 13;   // GD1 in px ; GD2 in point
        $marge        = 8;   // between barcode and hri in pixel
        $x            = $barcode[0]->pos_x;  // barcode center
        $y            = $barcode[0]->pos_y;  // barcode center
        $height       = $barcode[0]->code_height;   // barcode height in 1D ; module size in 2D
        $width        = $barcode[0]->code_width;    // barcode height in 1D ; not use in 2D
        //$width      = 2;    // barcode height in 1D ; not use in 2D
        $angle        = 0;   // rotation in degrees : nb : non horizontable barcode might not be usable because of pixelisation
        
        $code         = $this->data['pid']; // barcode, of course ;)
        $type         = $barcode[0]->code_type;
        $image_height = $barcode[0]->img_height;
        $image_width  = $barcode[0]->img_width;  
        // -------------------------------------------------- //
        //                    USEFUL
        // -------------------------------------------------- //
        
        // -------------------------------------------------- //
        //            ALLOCATE GD RESSOURCE
        // -------------------------------------------------- //
        $im     = imagecreatetruecolor($image_width, $image_height);
        $black  = ImageColorAllocate($im,0x00,0x00,0x00);
        $white  = ImageColorAllocate($im,0xff,0xff,0xff);
        $red    = ImageColorAllocate($im,0xff,0x00,0x00);
        $blue   = ImageColorAllocate($im,0x00,0x00,0xff);
        imagefilledrectangle($im, 0, 0, $image_width, $image_height, $white);
        
        // -------------------------------------------------- //
        //                      BARCODE
        // -------------------------------------------------- //
        $data = Barcode::gd($im, $black, $x, $y, $angle, $type, array('code'=>$code), $width, $height);
        
        // -------------------------------------------------- //
        //        HRI (Human readable Interpretation)
        // -------------------------------------------------- //
        if (isset($font)){
            $box = imagettfbbox($fontSize, 0, $font, $data['hri']);
            $len = $box[2] - $box[0];
            Barcode::rotate(-$len / 2, ($height / 2) + $fontSize + $marge, $angle, $xt, $yt);
            imagettftext($im, $fontSize, $angle, $x + $xt, $y + $yt, $black, $font, $data['hri']);
        }
        
        $success=imagepng($im, './public/uploaded_barcode/'.($this->data['pid']).image_type_to_extension(IMAGETYPE_PNG));
        imagedestroy($im);
        ($this->data['pid']).image_type_to_extension(IMAGETYPE_PNG);
 
        
        
        //Patient Bar code generating Start here----------------                
        $product_code = $this->data['voucher'];
        
        $barcode = $this->action->read('barcode');
        
        $font          = './private/fonts/arialbd.ttf';
        // - -
        
        $fontSize     = 13;   // GD1 in px ; GD2 in point
        $marge        = 8;   // between barcode and hri in pixel
        $x            = $barcode[0]->pos_x;  // barcode center
        $y            = $barcode[0]->pos_y;  // barcode center
        $height       = $barcode[0]->code_height;   // barcode height in 1D ; module size in 2D
        $width        =$barcode[0]->code_width;    // barcode height in 1D ; not use in 2D
        //$width      = 2;    // barcode height in 1D ; not use in 2D
        $angle        = 0;   // rotation in degrees : nb : non horizontable barcode might not be usable because of pixelisation
        
        $code         = $product_code; // barcode, of course ;)
        $type         = $barcode[0]->code_type;
        $image_height = $barcode[0]->img_height;
        $image_width  = $barcode[0]->img_width;  
        // -------------------------------------------------- //
        //                    USEFUL
        // -------------------------------------------------- //
        
        // -------------------------------------------------- //
        //            ALLOCATE GD RESSOURCE
        // -------------------------------------------------- //
        $im     = imagecreatetruecolor($image_width, $image_height);
        $black  = ImageColorAllocate($im,0x00,0x00,0x00);
        $white  = ImageColorAllocate($im,0xff,0xff,0xff);
        $red    = ImageColorAllocate($im,0xff,0x00,0x00);
        $blue   = ImageColorAllocate($im,0x00,0x00,0xff);
        imagefilledrectangle($im, 0, 0, $image_width, $image_height, $white);
        
        // -------------------------------------------------- //
        //                      BARCODE
        // -------------------------------------------------- //
        $data = Barcode::gd($im, $black, $x, $y, $angle, $type, array('code'=>$code), $width, $height);
        
        // -------------------------------------------------- //
        //        HRI (Human readable Interpretation)
        // -------------------------------------------------- //
        if (isset($font)){
            $box = imagettfbbox($fontSize, 0, $font, $data['hri']);
            $len = $box[2] - $box[0];
            Barcode::rotate(-$len / 2, ($height / 2) + $fontSize + $marge, $angle, $xt, $yt);
            imagettftext($im, $fontSize, $angle, $x + $xt, $y + $yt, $black, $font, $data['hri']);
        }
        
        
        $success=imagepng($im, './public/uploaded_barcode/'.$product_code.image_type_to_extension(IMAGETYPE_PNG));
        imagedestroy($im);
        // echo $code. image_type_to_extension(IMAGETYPE_PNG);
        $product_code.image_type_to_extension(IMAGETYPE_PNG);
        return $id; 
    }

     private function addJournal(){
      $regi_id = $this->action->read("registrations",array('pid'=> $this->input->post('pid')));


      $data = array(
            "date"    => $this->input->post('date'),
            "details" => "diagnosis",
            "amount"  => $this->input->post('paid'),
            "ref"     => "pid:".$this->input->post('pid'),
            "status"  => "income"
        );

      $this->action->add("journal",$data);   

      return true;
    }


    public function voucher(){
        $this->data['active'] = 'data-target="diagnosis-menu"';
        $this->data['subMenu'] = 'data-target="all"';
        
        $ultra_doctor_where = $refereed_doctor_where = $this->data['ultra_doctor'] = $this->data['refereed_doctor'] = $this->data['market'] = [];
        
        $where    = array('voucher' => $this->input->get("voucher"));
        $this->data['bill'] = $bills  = $this->data['bills'] = $this->action->read('bills', $where);

        $where    = ["diagnosis.bill"=> $bills[0]->id];

        $tableTo  = ['test', 'group_mapping', 'test_group'];
        $joinCond = ['diagnosis.test_id=test.id', 'test.id=group_mapping.test_id', 'group_mapping.group_id=test_group.id'];
        $select   = 'diagnosis.*, test.*, test_group.group_name';

        $this->data['diagnosis'] = $diagnosis = get_join('diagnosis', $tableTo, $joinCond, $where, $select, ['test.id']);
        $this->data['patientInfo'] = $this->action->read('patients', array("pid" => $bills[0]->pid));
        
        if(!empty($diagnosis[0]->alt_doctor_id || $diagnosis[0]->alt_doctor_id !=0)){
            $ultra_doctor_where = ['id'=>$diagnosis[0]->alt_doctor_id]; 
        }
        
        if(!empty($diagnosis[0]->refereed_doctor || $diagnosis[0]->refereed_doctor !=0)){
            $refereed_doctor_where = ['id'  => $diagnosis[0]->refereed_doctor]; 
        }
        
        $this->data['ultra_doctor']     =  get_name('doctors', 'fullName', $ultra_doctor_where);
        $this->data['refereed_doctor']  =  get_row('doctors', $refereed_doctor_where);
        
        if(isset($diagnosis[0]->reference_name)){
            $this->data['market'] = $this->action->read('marketer', ['id'=>$diagnosis[0]->reference_name]);
        }

        $this->load->view($this->data['privilege'].'/includes/header', $this->data);
        $this->load->view($this->data['privilege'].'/includes/aside', $this->data);
        $this->load->view($this->data['privilege'].'/includes/headermenu', $this->data);
        $this->load->view('components/diagnosis/nav', $this->data);
        $this->load->view('components/diagnosis/voucher', $this->data);
        $this->load->view($this->data['privilege'].'/includes/footer', $this->data);
    }


    public function status_check(){
        echo "This is Status";
    }


}